<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PostTag extends Model 
{

    protected $table = 'post_tag';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function post()
    {
        return $this->belongsTo('App\Models\Post', 'post_id');
    }

    public function tag()
    {
        return $this->belongsTo('App\Models\Tag', 'tag_id');
    }

}